<?php
// Pārbaudam, vai forma ir iesniegta
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validējam formas datus
    if (isset($_POST['test_id']) && isset($_POST['name']) && isset($_POST['category'])) {
        // Izvextractējam formas datus
        $test_id = $_POST['test_id'];
        $name = $_POST['name'];
        $category = $_POST['category'];

        // Savienojamies ar datubāzi
        $conn = new mysqli("localhost", "root", "", "quiz_db");
        if ($conn->connect_error) {
            die("Savienojums neizdevās: " . $conn->connect_error);
        }

        // Sagatavojam un izpildām SQL pieprasījumu, lai atjaunotu testu
        $sql = "UPDATE tests SET name=?, category=? WHERE id=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssi", $name, $category, $test_id);
        $stmt->execute();

        // Pārbaudam, vai atjaunināšana bija veiksmīga
        if ($stmt->affected_rows > 0) {
            header("Location: manage_tests.php"); // Novirzām uz manage_tests.php lapu
            exit(); // Nodrošinām, ka pēc novirzīšanas netiek izpildīts turpmākais kods
        } else {
            echo "Kļūda, atjaunojot testu: " . $conn->error;
        }

        // Aizveram datubāzes savienojumu un izpildāmās vides objektu
        $stmt->close();
        $conn->close();
    } else {
        echo "Nederīgi formas dati.";
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>Rediģēt Testu</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <style>
        h1 {
            text-align: center;
            margin-top: 20px;
            font-size: 24px;
        }
        form {
            display: flex;
            flex-direction: column;
            align-items: center;
            width: 100%;
            max-width: 400px;
            margin: 0 auto;
        }
        label, input, button {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
        }
        button {
            background-color: #333;
            color: #fff;
            border: none;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        button:hover {
            background-color: #555;
        }
    </style>
</head>
<body>
    <?php include('../php/check_admin.php'); ?>

    <!-- Navigācijas josla -->
    <div id="navbar">
        <div id="logo" onclick="redirectToHomePage()">LOGO</div>
        <div id="profileBtn" class="dropdown" onclick="toggleDropdown()">Profils
            <div class="dropdown-content" id="dropdownContent">
                <a href="../html/change_password.html">Mainīt paroli</a>
                <a href="../php/logout.php">Iziet</a>
            </div>
        </div>
    </div>

    <h1>Rediģēt Testu</h1>
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <?php
        // Izveidojam datubāzes savienojumu
        $conn = new mysqli("localhost", "root", "", "quiz_db");
        if ($conn->connect_error) {
            die("Savienojums neizdevās: " . $conn->connect_error);
        }

        if (isset($_GET['test_id'])) {
            $test_id = $_GET['test_id'];

            // Izvelkam testu no datubāzes pēc tā ID
            $sql = "SELECT * FROM tests WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i", $test_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $test = $result->fetch_assoc();

            if ($test) {
                echo '<input type="hidden" name="test_id" value="' . $test['id'] . '">';
                echo '<label for="name">Nosaukums:</label>';
                echo '<input type="text" id="name" name="name" value="' . $test['name'] . '" required>';
                echo '<label for="category">Kategorija:</label>';
                echo '<input type="text" id="category" name="category" value="' . $test['category'] . '" required>';
            }

            $stmt->close();
        }

        $conn->close();
        ?>
        <button type="submit">Saglabāt</button>
    </form>

    <script src="../js/redirects.js"></script>
</body>
</html>

